/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define([],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.Lang=factory()}})(this,function(){"use strict";function inferLocale(){if(typeof document!=="undefined"&&document.documentElement){return document.documentElement.lang}}function convertNumber(str){if(str==="-Inf"){return-Infinity}else if(str==="+Inf"||str==="Inf"||str==="*"){return Infinity}return parseInt(str,10)}var intervalRegexp=/^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;var anyIntervalRegexp=/({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;var defaults={locale:"en"};var Lang=function(options){options=options||{};this.locale=options.locale||inferLocale()||defaults.locale;this.fallback=options.fallback;this.messages=options.messages};Lang.prototype.setMessages=function(messages){this.messages=messages};Lang.prototype.getLocale=function(){return this.locale||this.fallback};Lang.prototype.setLocale=function(locale){this.locale=locale};Lang.prototype.getFallback=function(){return this.fallback};Lang.prototype.setFallback=function(fallback){this.fallback=fallback};Lang.prototype.has=function(key,locale){if(typeof key!=="string"||!this.messages){return false}return this._getMessage(key,locale)!==null};Lang.prototype.get=function(key,replacements,locale){if(!this.has(key,locale)){return key}var message=this._getMessage(key,locale);if(message===null){return key}if(replacements){message=this._applyReplacements(message,replacements)}return message};Lang.prototype.trans=function(key,replacements){return this.get(key,replacements)};Lang.prototype.choice=function(key,number,replacements,locale){replacements=typeof replacements!=="undefined"?replacements:{};replacements.count=number;var message=this.get(key,replacements,locale);if(message===null||message===undefined){return message}var messageParts=message.split("|");var explicitRules=[];for(var i=0;i<messageParts.length;i++){messageParts[i]=messageParts[i].trim();if(anyIntervalRegexp.test(messageParts[i])){var messageSpaceSplit=messageParts[i].split(/\s/);explicitRules.push(messageSpaceSplit.shift());messageParts[i]=messageSpaceSplit.join(" ")}}if(messageParts.length===1){return message}for(var j=0;j<explicitRules.length;j++){if(this._testInterval(number,explicitRules[j])){return messageParts[j]}}var pluralForm=this._getPluralForm(number);return messageParts[pluralForm]};Lang.prototype.transChoice=function(key,count,replacements){return this.choice(key,count,replacements)};Lang.prototype._parseKey=function(key,locale){if(typeof key!=="string"||typeof locale!=="string"){return null}var segments=key.split(".");var source=segments[0].replace(/\//g,".");return{source:locale+"."+source,sourceFallback:this.getFallback()+"."+source,entries:segments.slice(1)}};Lang.prototype._getMessage=function(key,locale){locale=locale||this.getLocale();key=this._parseKey(key,locale);if(this.messages[key.source]===undefined&&this.messages[key.sourceFallback]===undefined){return null}var message=this.messages[key.source];var entries=key.entries.slice();var subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]!==undefined){message=message[subKey];subKey=""}}if(typeof message!=="string"&&this.messages[key.sourceFallback]){message=this.messages[key.sourceFallback];entries=key.entries.slice();subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]){message=message[subKey];subKey=""}}}if(typeof message!=="string"){return null}return message};Lang.prototype._findMessageInTree=function(pathSegments,tree){while(pathSegments.length&&tree!==undefined){var dottedKey=pathSegments.join(".");if(tree[dottedKey]){tree=tree[dottedKey];break}tree=tree[pathSegments.shift()]}return tree};Lang.prototype._applyReplacements=function(message,replacements){for(var replace in replacements){message=message.replace(new RegExp(":"+replace,"gi"),function(match){var value=replacements[replace];var allCaps=match===match.toUpperCase();if(allCaps){return value.toUpperCase()}var firstCap=match===match.replace(/\w/i,function(letter){return letter.toUpperCase()});if(firstCap){return value.charAt(0).toUpperCase()+value.slice(1)}return value})}return message};Lang.prototype._testInterval=function(count,interval){if(typeof interval!=="string"){throw"Invalid interval: should be a string."}interval=interval.trim();var matches=interval.match(intervalRegexp);if(!matches){throw"Invalid interval: "+interval}if(matches[2]){var items=matches[2].split(",");for(var i=0;i<items.length;i++){if(parseInt(items[i],10)===count){return true}}}else{matches=matches.filter(function(match){return!!match});var leftDelimiter=matches[1];var leftNumber=convertNumber(matches[2]);if(leftNumber===Infinity){leftNumber=-Infinity}var rightNumber=convertNumber(matches[3]);var rightDelimiter=matches[4];return(leftDelimiter==="["?count>=leftNumber:count>leftNumber)&&(rightDelimiter==="]"?count<=rightNumber:count<rightNumber)}return false};Lang.prototype._getPluralForm=function(count){switch(this.locale){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return count==1?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return count===0||count===1?0:1;case"be":case"bs":case"hr":case"ru":case"sr":case"uk":return count%10==1&&count%100!=11?0:count%10>=2&&count%10<=4&&(count%100<10||count%100>=20)?1:2;case"cs":case"sk":return count==1?0:count>=2&&count<=4?1:2;case"ga":return count==1?0:count==2?1:2;case"lt":return count%10==1&&count%100!=11?0:count%10>=2&&(count%100<10||count%100>=20)?1:2;case"sl":return count%100==1?0:count%100==2?1:count%100==3||count%100==4?2:3;case"mk":return count%10==1?0:1;case"mt":return count==1?0:count===0||count%100>1&&count%100<11?1:count%100>10&&count%100<20?2:3;case"lv":return count===0?0:count%10==1&&count%100!=11?1:2;case"pl":return count==1?0:count%10>=2&&count%10<=4&&(count%100<12||count%100>14)?1:2;case"cy":return count==1?0:count==2?1:count==8||count==11?2:3;case"ro":return count==1?0:count===0||count%100>0&&count%100<20?1:2;case"ar":return count===0?0:count==1?1:count==2?2:count%100>=3&&count%100<=10?3:count%100>=11&&count%100<=99?4:5;default:return 0}};return Lang});

(function () {
    Lang = new Lang();
    Lang.setMessages({"ar.js":{"admin":"\u0645\u0633\u0624\u0644","all":"\u0627\u0644\u062c\u0645\u064a\u0639","all_notification_read_successfully":"\u062a\u0645\u062a \u0642\u0631\u0627\u0621\u0629 \u0643\u0627\u0641\u0629 \u0627\u0644\u0625\u062e\u0637\u0627\u0631\u0627\u062a \u0628\u0646\u062c\u0627\u062d","amount_should_be_less_than_payable_amount":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0623\u0642\u0644 \u0645\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0645\u0633\u062a\u062d\u0642.","apply":"\u064a\u062a\u0642\u062f\u0645","apr":"\u0623\u0628\u0631\u064a\u0644","are_sure_want_to_delete_this_client_related_all_invoices":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u062d\u0630\u0641 \u062c\u0645\u064a\u0639 \u0627\u0644\u0641\u0648\u0627\u062a\u064a\u0631 \u0627\u0644\u0645\u062a\u0639\u0644\u0642\u0629 \u0628\u0647\u0630\u0627 \u0627\u0644\u0639\u0645\u064a\u0644\u061f","are_you_sure_delete":"\u0647\u0644 \u062a\u0631\u064a\u062f \u0628\u0627\u0644\u062a\u0623\u0643\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0627","are_you_sure_send":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0625\u0631\u0633\u0627\u0644 \u0647\u0630\u0647 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629 \u0625\u0644\u0649 \u0627\u0644\u0639\u0645\u064a\u0644\u061f","aug":"\u0623\u063a\u0633\u0637\u0633","cancel":"\u064a\u0644\u063a\u064a","category":"\u0641\u0626\u0629","client":"\u0639\u0645\u064a\u0644","currency":"\u0639\u0645\u0644\u0629","custom":"\u0646\u0637\u0627\u0642 \u0645\u062e\u0635\u0635","dec":"\u062f\u064a\u0633\u0645\u0628\u0631","delete":"\u064a\u0645\u0633\u062d","deleted":"\u062a\u0645 \u0627\u0644\u062d\u0630\u0641!","error":"\u062e\u0637\u0623","feb":"\u0641\u0628\u0631\u0627\u064a\u0631","fri":"\u0627\u0644\u062c\u0645\u0639\u0629","from":"\u0645\u0646","has_been_deleted":"\u0642\u062f \u062a\u0645 \u062d\u0630\u0641.","hello":"\u0645\u0631\u062d\u0628\u064b\u0627","invalid_country_number":"\u0631\u0642\u0645 \u0627\u0644\u0628\u0644\u062f \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","invalid_number":"\u0631\u0642\u0645 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","invoice":"\u0641\u0627\u062a\u0648\u0631\u0629","jan":"\u064a\u0646\u0627\u064a\u0631","jul":"\u064a\u0648\u0644\u064a\u0648","jun":"\u064a\u0648\u0646\u064a\u0648","language_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d","last_30_days":"\u0622\u062e\u0631 30 \u064a\u0648\u0645\u064b\u0627","last_7_days":"\u0627\u062e\u0631 7 \u0627\u064a\u0627\u0645","last_month":"\u0627\u0644\u0634\u0647\u0631 \u0627\u0644\u0645\u0627\u0636\u064a","last_week":"\u0627\u0644\u0623\u0633\u0628\u0648\u0639 \u0627\u0644\u0645\u0627\u0636\u064a","mar":"\u0645\u0627\u0631\u0633","may":"\u064a\u0645\u0643\u0646","mon":"\u0645\u0648\u0646","new_invoice":"\u0641\u0627\u062a\u0648\u0631\u0629 \u062c\u062f\u064a\u062f\u0629","no_cancel":"\u0644\u0627\u060c \u0625\u0644\u063a\u0627\u0621","no_record_found":"\u0644\u0627 \u064a\u0648\u062c\u062f \u0633\u062c\u0644\u0627\u062a","notification_read_successfully":"\u062a\u0645\u062a \u0642\u0631\u0627\u0621\u0629 \u0627\u0644\u0625\u0634\u0639\u0627\u0631 \u0628\u0646\u062c\u0627\u062d","nov":"\u0646\u0648\u0641\u0645\u0628\u0631","oct":"\u0633\u0628\u062a\u0645\u0628\u0631","ok":"\u0646\u0639\u0645","payment":"\u0642\u0633\u0637","payment_qr_code":"\u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629 \u0644\u0644\u062f\u0641\u0639","product":"\u0645\u0646\u062a\u062c","quote":"\u064a\u0642\u062a\u0628\u0633","sat":"\u0642\u0639\u062f","select_product_or_enter_free_text":"\u062d\u062f\u062f \u0627\u0644\u0645\u0646\u062a\u062c \u0623\u0648 \u0623\u062f\u062e\u0644 \u0646\u0635\u064b\u0627 \u062d\u0631\u064b\u0627","select_tax":"\u062d\u062f\u062f \u0627\u0644\u0636\u0631\u064a\u0628\u0629","send_invoice":"\u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0641\u0627\u062a\u0648\u0631\u0629","sep":"\u0633\u0628\u062a\u0645\u0628\u0631","sun":"\u0634\u0645\u0633","tax":"\u0636\u0631\u064a\u0628\u0629","this_month":"\u0647\u0630\u0627 \u0627\u0644\u0634\u0647\u0631","this_week":"\u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0628\u0648\u0639","thu":"\u0627\u0644\u062e\u0645\u064a\u0633","to":"\u0644","today":"\u0627\u0644\u064a\u0648\u0645","too_long":"\u0637\u0648\u064a\u0644 \u062c\u062f\u0627","too_short":"\u0642\u0635\u064a\u0631 \u062c\u062f\u0627","tue":"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621","valid_number":"\u0635\u0627\u0644\u062d","wed":"\u062a\u0632\u0648\u062c","yes_delete":"\u0646\u0639\u0645\u060c \u0627\u062d\u0630\u0641!","yes_send":"\u0646\u0639\u0645 \u0627\u0631\u0633\u0644","yesterday":"\u0623\u0645\u0633"},"de.js":{"admin":"Administrator","all":"Alle","all_notification_read_successfully":"Alle Benachrichtigungen wurden erfolgreich gelesen","amount_should_be_less_than_payable_amount":"Der Betrag sollte unter dem zu zahlenden Betrag liegen.","apply":"Anwenden","apr":"Apr","are_sure_want_to_delete_this_client_related_all_invoices":"M\u00f6chten Sie wirklich alle Rechnungen dieses Kunden l\u00f6schen?","are_you_sure_delete":"M\u00f6chten Sie dies wirklich l\u00f6schen?","are_you_sure_send":"M\u00f6chten Sie diese Rechnung wirklich an den Kunden senden?","aug":"Aug","cancel":"Stornieren","category":"Kategorie","client":"Klient","currency":"W\u00e4hrung","custom":"Benutzerdefinierten Bereich","dec":"Dez","delete":"L\u00f6schen","deleted":"Gel\u00f6scht!","error":"Fehler","feb":"Febr","fri":"FR","from":"Aus","has_been_deleted":"wurde gel\u00f6scht.","invalid_country_number":"Ung\u00fcltige L\u00e4ndernummer","invalid_number":"Ung\u00fcltige Nummer","invoice":"RECHNUNG","jan":"Jan","jul":"Juli","jun":"Jun","language_updated_successfully":"Sprache erfolgreich aktualisiert","last_30_days":"Letzte 30 Tage","last_7_days":"Letzten 7 Tage","last_month":"Im vergangenen Monat","last_week":"Letzte Woche","mar":"Besch\u00e4digen","may":"Mai","mon":"MO","new_invoice":"Neue Rechnung","no_cancel":"Nein, Abbrechen","no_record_found":"Kein Eintrag gefunden","notification_read_successfully":"Benachrichtigung erfolgreich gelesen","nov":"Nov","oct":"Okt","ok":"OK","payment":"Zahlung","payment_qr_code":"Zahlungs-QR-Code","product":"Produkt","quote":"Zitat","sat":"SA","select_product_or_enter_free_text":"Produkt ausw\u00e4hlen oder Freitext eingeben","select_tax":"W\u00e4hlen Sie Steuer aus","send_invoice":"Rechnung senden","sep":"Sept","sun":"SONNE","tax":"Steuer","this_month":"Diesen Monat","this_week":"Diese Woche","thu":"DO","to":"Zu","today":"Heute","too_long":"Zu lang","too_short":"Zu kurz","tue":"DI","valid_number":"G\u00fcltig","wed":"HEIRATEN","yes_delete":"Ja, l\u00f6schen!","yes_send":"Ja, senden","yesterday":"Gestern"},"en.js":{"admin":"Admin","all":"All","all_notification_read_successfully":"All notification read successfully","amount_should_be_less_than_payable_amount":"Amount should be less than payable amount.","apply":"Apply","apr":"Apr","are_sure_want_to_delete_this_client_related_all_invoices":"Are you sure want to delete this client related all invoices ?","are_you_sure_delete":"Are you sure want to delete this","are_you_sure_send":"Are you sure want to send this invoice to client ?","aug":"Aug","cancel":"Cancel","category":"Category","client":"Client","currency":"Currency","custom":"Custom Range","dec":"Dec","delete":"Delete","deleted":"Deleted!","error":"Error","feb":"Feb","fri":"FRI","from":"From","has_been_deleted":"has been deleted.","hello":"Hello","invalid_country_number":"Invalid country number","invalid_number":"Invalid number","invoice":"INVOICE","jan":"Jan","jul":"Jul","jun":"Jun","language_updated_successfully":"Language updated successfully","last_30_days":"Last 30 Days","last_7_days":"Last 7 Days","last_month":"Last Month","last_week":"Last Week","mar":"Mar","may":"May","mon":"MON","new_invoice":"New Invoice","no_cancel":"No, Cancel","no_record_found":"No Record Found","notification_read_successfully":"Notification read successfully","nov":"Nov","oct":"Oct","ok":"Ok","payment":"Payment","payment_qr_code":"Payment QR Code","product":"Product","quote":"Quote","sat":"SAT","select_product_or_enter_free_text":"Select Product or Enter free text","select_tax":"Select Tax","send_invoice":"Send Invoice","sep":"Sep","sun":"SUN","tax":"Tax","this_month":"This Month","this_week":"This Week","thu":"THU","to":"To","today":"Today","too_long":"Too long","too_short":"Too short","tue":"TUE","valid_number":"Valid","wed":"WED","yes_delete":"Yes, Delete!","yes_send":"Yes, Send","yesterday":"Yesterday"},"es.js":{"admin":"Administrador","all":"Todo","all_notification_read_successfully":"Todas las notificaciones se leyeron correctamente","amount_should_be_less_than_payable_amount":"El monto debe ser menor que el monto a pagar.","apply":"Aplicar","apr":"Abr","are_sure_want_to_delete_this_client_related_all_invoices":"\u00bfEst\u00e1 seguro de que desea eliminar todas las facturas relacionadas con este cliente?","are_you_sure_delete":"\u00bfEst\u00e1s seguro de que quieres eliminar esto?","are_you_sure_send":"\u00bfEst\u00e1 seguro de que desea enviar esta factura al cliente?","aug":"Ago","cancel":"Cancelar","category":"Categor\u00eda","client":"Cliente","currency":"Divisa","custom":"Rango personalizado","dec":"Dic","delete":"Borrar","deleted":"\u00a1Eliminado!","error":"Error","feb":"Feb","fri":"VIE","from":"De","has_been_deleted":"ha sido eliminado.","invalid_country_number":"N\u00famero de pa\u00eds no v\u00e1lido","invalid_number":"N\u00famero invalido","invoice":"FACTURA","jan":"Ene","jul":"Jul","jun":"Jun","language_updated_successfully":"Idioma actualizado exitosamente","last_30_days":"\u00daltimos 30 d\u00edas","last_7_days":"Los \u00faltimos 7 d\u00edas","last_month":"El mes pasado","last_week":"La semana pasada","mar":"Mar","may":"Puede","mon":"LUN","new_invoice":"Nueva factura","no_cancel":"No, cancelar","no_record_found":"ning\u00fan record fue encontrado","notification_read_successfully":"Notificaci\u00f3n le\u00edda exitosamente","nov":"Nov","oct":"Oct","ok":"De acuerdo","payment":"Pago","payment_qr_code":"C\u00f3digo QR de pago","product":"Producto","quote":"Cita","sat":"SE SENT\u00d3","select_product_or_enter_free_text":"Selecciona Producto o Introduce texto libre","select_tax":"Seleccionar Impuesto","send_invoice":"Enviar\u00e1 la factura","sep":"Sep","sun":"SOL","tax":"Impuesto","this_month":"Este mes","this_week":"Esta semana","thu":"JUE","to":"A","today":"Hoy","too_long":"Demasiado largo","too_short":"Demasiado corto","tue":"MAR","valid_number":"V\u00e1lido","wed":"CASARSE","yes_delete":"\u00a1S\u00ed, eliminar!","yes_send":"Si env\u00edalo","yesterday":"Ayer"},"fr.js":{"admin":"Administrateur","all":"Tout","all_notification_read_successfully":"Toutes les notifications ont \u00e9t\u00e9 lues avec succ\u00e8s","amount_should_be_less_than_payable_amount":"Le montant doit \u00eatre inf\u00e9rieur au montant \u00e0 payer.","apply":"Appliquer","apr":"Avr","are_sure_want_to_delete_this_client_related_all_invoices":"Etes-vous s\u00fbr de vouloir supprimer toutes les factures li\u00e9es \u00e0 ce client\u00a0?","are_you_sure_delete":"\u00cates-vous s\u00fbr de vouloir supprimer ceci","are_you_sure_send":"Etes-vous s\u00fbr de vouloir envoyer cette facture au client\u00a0?","aug":"Ao\u00fbt","cancel":"Annuler","category":"Cat\u00e9gorie","client":"Client","currency":"Devise","custom":"Gamme personnalis\u00e9e","dec":"D\u00e9c","delete":"Supprimer","deleted":"Supprim\u00e9\u00a0!","error":"Erreur","feb":"F\u00e9v","fri":"VEN","from":"Depuis","has_been_deleted":"a \u00e9t\u00e9 supprim\u00e9.","invalid_country_number":"Num\u00e9ro de pays invalide","invalid_number":"Num\u00e9ro invalide","invoice":"FACTURE","jan":"Jan","jul":"Juillet","jun":"juin","language_updated_successfully":"Langue mise \u00e0 jour avec succ\u00e8s","last_30_days":"Les 30 derniers jours","last_7_days":"Les 7 derniers jours","last_month":"Le mois dernier","last_week":"La semaine derni\u00e8re","mar":"Mar","may":"Peut","mon":"LUN","new_invoice":"Nouvelle facture","no_cancel":"Non, annuler","no_record_found":"Aucun Enregistrement Trouv\u00e9","notification_read_successfully":"Notification lue avec succ\u00e8s","nov":"Nov","oct":"Octobre","ok":"D'accord","payment":"Paiement","payment_qr_code":"Code QR de paiement","product":"Produit","quote":"Citation","sat":"ASSIS","select_product_or_enter_free_text":"S\u00e9lectionnez un produit ou saisissez un texte libre","select_tax":"S\u00e9lectionnez la taxe","send_invoice":"Envoyer une facture","sep":"Sep","sun":"SOLEIL","tax":"Imp\u00f4t","this_month":"Ce mois-ci","this_week":"Cette semaine","thu":"JEU","to":"\u00c0","today":"Aujourd'hui","too_long":"Trop long","too_short":"Trop court","tue":"MAR","valid_number":"Valide","wed":"\u00c9POUSER","yes_delete":"Oui, supprimez\u00a0!","yes_send":"Oui envoyer","yesterday":"Hier"},"pt.js":{"admin":"Administrador","all":"Todos","all_notification_read_successfully":"Todas as notifica\u00e7\u00f5es foram lidas com sucesso","amount_should_be_less_than_payable_amount":"O valor deve ser inferior ao valor a pagar.","apply":"Aplicar","apr":"abril","are_sure_want_to_delete_this_client_related_all_invoices":"Tem certeza de que deseja excluir todas as faturas relacionadas a este cliente?","are_you_sure_delete":"Tem certeza de que deseja excluir isto","are_you_sure_send":"Tem certeza de que deseja enviar esta fatura ao cliente?","aug":"Agosto","cancel":"Cancelar","category":"Categoria","client":"Cliente","currency":"Moeda","custom":"Intervalo personalizado","dec":"dezembro","delete":"Excluir","deleted":"Exclu\u00eddo!","error":"Erro","feb":"fevereiro","fri":"SEX","from":"De","has_been_deleted":"foi deletado.","invalid_country_number":"N\u00famero de pa\u00eds inv\u00e1lido","invalid_number":"N\u00famero inv\u00e1lido","invoice":"FATURA","jan":"janeiro","jul":"julho","jun":"junho","language_updated_successfully":"Idioma atualizado com sucesso","last_30_days":"\u00daltimos 30 dias","last_7_days":"\u00daltimos 7 dias","last_month":"M\u00eas passado","last_week":"Semana passada","mar":"mar\u00e7o","may":"Poderia","mon":"SEG","new_invoice":"Nova fatura","no_cancel":"N\u00e3o, cancelar","no_record_found":"Nenhum Registro Encontrado","notification_read_successfully":"Notifica\u00e7\u00e3o lida com sucesso","nov":"novembro","oct":"Outubro","ok":"OK","payment":"Pagamento","payment_qr_code":"C\u00f3digo QR de pagamento","product":"produtos","quote":"Citar","sat":"SENTADO","select_product_or_enter_free_text":"Selecione Produto ou Insira texto livre","select_tax":"Selecione Imposto","send_invoice":"Enviar fatura","sep":"Setembro","sun":"SOL","tax":"Imposto","this_month":"Este m\u00eas","this_week":"Essa semana","thu":"QUI","to":"Para","today":"Hoje","too_long":"Demasiado longo","too_short":"Muito curto","tue":"TER","valid_number":"V\u00e1lido","wed":"QUA","yes_delete":"Sim, excluir!","yes_send":"Sim envie","yesterday":"Ontem"},"ru.js":{"admin":"\u0410\u0434\u043c\u0438\u043d","all":"\u0412\u0441\u0435","all_notification_read_successfully":"\u0412\u0441\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u044b","amount_should_be_less_than_payable_amount":"\u0421\u0443\u043c\u043c\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0441\u0443\u043c\u043c\u044b \u043a \u043e\u043f\u043b\u0430\u0442\u0435.","apply":"\u041f\u0440\u0438\u043c\u0435\u043d\u044f\u0442\u044c","apr":"\u0430\u043f\u0440\u0435\u043b\u044c","are_sure_want_to_delete_this_client_related_all_invoices":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u0441\u0447\u0435\u0442\u0430, \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0441 \u044d\u0442\u0438\u043c \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c?","are_you_sure_delete":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e?","are_you_sure_send":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0441\u0447\u0435\u0442 \u043a\u043b\u0438\u0435\u043d\u0442\u0443?","aug":"\u0430\u0432\u0433\u0443\u0441\u0442","cancel":"\u041e\u0442\u043c\u0435\u043d\u0430","category":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f","client":"\u041a\u043b\u0438\u0435\u043d\u0442","currency":"\u0412\u0430\u043b\u044e\u0442\u0430","custom":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d","dec":"\u0434\u0435\u043a\u0430\u0431\u0440\u044c","delete":"\u0423\u0434\u0430\u043b\u0438\u0442\u044c","deleted":"\u0423\u0434\u0430\u043b\u0435\u043d\u043e!","error":"\u041e\u0448\u0438\u0431\u043a\u0430","feb":"\u0444\u0435\u0432\u0440\u0430\u043b\u044c","fri":"\u041f\u0422","from":"\u041e\u0442","has_been_deleted":"\u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d.","invalid_country_number":"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u0430\u043d\u044b","invalid_number":"\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","invoice":"\u0421\u0427\u0415\u0422","jan":"\u042f\u043d","jul":"\u0438\u044e\u043b\u044c","jun":"\u0438\u044e\u043d\u044c","language_updated_successfully":"\u042f\u0437\u044b\u043a \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d","last_30_days":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 30 \u0434\u043d\u0435\u0439","last_7_days":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 7 \u0434\u043d\u0435\u0439","last_month":"\u041f\u0440\u043e\u0448\u043b\u044b\u0439 \u043c\u0435\u0441\u044f\u0446","last_week":"\u041d\u0430 \u043f\u0440\u043e\u0448\u043b\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","mar":"\u041c\u0430\u0440","may":"\u041c\u043e\u0436\u0435\u0442","mon":"\u041f\u041d","new_invoice":"\u041d\u043e\u0432\u044b\u0439 \u0441\u0447\u0435\u0442","no_cancel":"\u041d\u0435\u0442, \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c","no_record_found":"\u0417\u0430\u043f\u0438\u0441\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430","notification_read_successfully":"\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e","nov":"\u043d\u043e\u044f\u0431\u0440\u044c","oct":"\u043e\u043a\u0442\u044f\u0431\u0440\u044c","ok":"\u0425\u043e\u0440\u043e\u0448\u043e","payment":"\u041e\u043f\u043b\u0430\u0442\u0430","payment_qr_code":"QR-\u043a\u043e\u0434 \u043e\u043f\u043b\u0430\u0442\u044b","product":"\u041f\u0440\u043e\u0434\u0443\u043a\u0442","quote":"\u0426\u0438\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c","sat":"\u0421\u0418\u0414\u0415\u041b","select_product_or_enter_free_text":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0438\u043b\u0438 \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442","select_tax":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u043b\u043e\u0433","send_invoice":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0443","sep":"\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c","sun":"\u0421\u041e\u041b\u041d\u0426\u0415","tax":"\u041d\u0430\u043b\u043e\u0433","this_month":"\u042d\u0442\u043e\u0442 \u043c\u0435\u0441\u044f\u0446","this_week":"\u041d\u0430 \u044d\u0442\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","thu":"\u0427\u0422","to":"\u041a","today":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f","too_long":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043e\u043b\u0433\u043e","too_short":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0439","tue":"\u0412\u0422","valid_number":"\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439","wed":"\u041e\u0411\u0412\u0415\u041d\u0427\u0410\u041b\u0418\u0421\u042c","yes_delete":"\u0414\u0430, \u0443\u0434\u0430\u043b\u0438\u0442\u044c!","yesterday":"\u0412\u0447\u0435\u0440\u0430"},"tr.js":{"admin":"Y\u00f6netici","all":"T\u00fcm","all_notification_read_successfully":"T\u00fcm bildirimler ba\u015far\u0131yla okundu","amount_should_be_less_than_payable_amount":"Tutar \u00f6denecek tutardan az olmal\u0131d\u0131r.","apply":"Uygula","apr":"Nisan","are_sure_want_to_delete_this_client_related_all_invoices":"Bu m\u00fc\u015fteriyle ilgili t\u00fcm faturalar\u0131 silmek istedi\u011finizden emin misiniz?","are_you_sure_delete":"Bunu silmek istedi\u011finden emin misin?","are_you_sure_send":"Bu faturay\u0131 m\u00fc\u015fteriye g\u00f6ndermek istedi\u011finizden emin misiniz?","aug":"A\u011fustos","cancel":"\u0130ptal etmek","category":"Kategori","client":"M\u00fc\u015fteri","currency":"Para birimi","custom":"\u00d6zel Aral\u0131k","dec":"Aral\u0131k","delete":"Silmek","deleted":"Silindi!","error":"Hata","feb":"\u015eubat","fri":"Cuma","from":"\u0130tibaren","has_been_deleted":"silindi.","invalid_country_number":"Ge\u00e7ersiz \u00fclke numaras\u0131","invalid_number":"Ge\u00e7ersiz numara","invoice":"FATURA","jan":"Ocak","jul":"Temmuz","jun":"Haziran","language_updated_successfully":"Dil ba\u015far\u0131yla g\u00fcncellendi","last_30_days":"Son 30 g\u00fcn","last_7_days":"Son 7 g\u00fcn","last_month":"Ge\u00e7en ay","last_week":"Ge\u00e7en hafta","mar":"Mart","may":"May\u0131s","mon":"PZT","new_invoice":"Yeni fatura","no_cancel":"Hay\u0131r, \u0130ptal","no_record_found":"Kay\u0131t Bulunamad\u0131","notification_read_successfully":"Bildirim ba\u015far\u0131yla okundu","nov":"Kas\u0131m","oct":"Ekim","ok":"Tamam","payment":"\u00d6deme","payment_qr_code":"\u00d6deme QR Kodu","product":"\u00dcr\u00fcn","quote":"Al\u0131nt\u0131","sat":"DOYGUNLUK","select_product_or_enter_free_text":"\u00dcr\u00fcn Se\u00e7in veya Serbest Metin Girin","select_tax":"Vergi Se\u00e7iniz","send_invoice":"Fatura G\u00f6nder","sep":"Eyl\u00fcl","sun":"G\u00dcNE\u015e","tax":"Vergi","this_month":"Bu ay","this_week":"Bu hafta","thu":"per\u015f","to":"\u0130le","today":"Bug\u00fcn","too_long":"\u00c7ok uzun","too_short":"\u00c7ok k\u0131sa","tue":"SALI","valid_number":"Ge\u00e7erli","wed":"EVLENMEK","yes_delete":"Evet, Sil!","yesterday":"D\u00fcn"},"zh.js":{"admin":"\u884c\u653f","all":"\u5168\u90e8","all_notification_read_successfully":"\u6240\u6709\u901a\u77e5\u8b80\u53d6\u6210\u529f","amount_should_be_less_than_payable_amount":"\u91d1\u984d\u61c9\u5c0f\u65bc\u61c9\u4ed8\u91d1\u984d\u3002","apply":"\u7533\u8acb","apr":"\u56db\u6708","are_sure_want_to_delete_this_client_related_all_invoices":"\u60a8\u78ba\u5b9a\u8981\u522a\u9664\u8a72\u5ba2\u6236\u76f8\u95dc\u7684\u6240\u6709\u767c\u7968\u55ce\uff1f","are_you_sure_delete":"\u60a8\u78ba\u5b9a\u8981\u522a\u9664\u6b64\u5167\u5bb9\u55ce","are_you_sure_send":"\u60a8\u78ba\u5b9a\u8981\u5c07\u6b64\u767c\u7968\u5bc4\u7d66\u5ba2\u6236\u55ce\uff1f","aug":"\u516b\u6708","cancel":"\u53d6\u6d88","category":"\u985e\u5225","client":"\u5ba2\u6236","currency":"\u8ca8\u5e63","custom":"\u5b9a\u5236\u7bc4\u570d","dec":"\u5341\u4e8c\u6708","delete":"\u522a\u9664","deleted":"\u5df2\u522a\u9664\uff01","error":"\u932f\u8aa4","feb":"\u4e8c\u6708","fri":"\u5f17\u745e","from":"\u5f9e","has_been_deleted":"\u5df2\u522a\u9664\u3002","invalid_country_number":"\u570b\u5bb6\u865f\u78bc\u7121\u6548","invalid_number":"\u7121\u6548\u865f\u78bc","invoice":"\u767c\u7968","jan":"\u63da","jul":"\u4e03\u6708","jun":"\u541b","language_updated_successfully":"\u8a9e\u8a00\u66f4\u65b0\u6210\u529f","last_30_days":"\u904e\u53bb 30 \u5929","last_7_days":"\u904e\u53bb 7 \u5929","last_month":"\u4e0a\u500b\u6708","last_week":"\u4e0a\u500b\u661f\u671f","mar":"\u4e09\u6708","may":"\u53ef\u80fd","mon":"\u9031\u4e00","new_invoice":"\u65b0\u767c\u7968","no_cancel":"\u4e0d\uff0c\u53d6\u6d88","no_record_found":"\u6c92\u6709\u627e\u5230\u8a18\u9304","notification_read_successfully":"\u901a\u77e5\u8b80\u53d6\u6210\u529f","nov":"\u5341\u4e00\u6708","oct":"\u5341\u6708","ok":"\u597d\u7684","payment":"\u652f\u4ed8","payment_qr_code":"\u652f\u4ed8\u4e8c\u7dad\u78bc","product":"\u7522\u54c1","quote":"\u5f15\u7528","sat":"SAT","select_product_or_enter_free_text":"\u9078\u64c7\u7522\u54c1\u6216\u8f38\u5165\u81ea\u7531\u6587\u5b57","select_tax":"\u9078\u64c7\u7a05\u8cbb","send_invoice":"\u5bc4\u51fa\u767c\u7968","sep":"\u4e5d\u6708","sun":"\u592a\u967d","tax":"\u7a05","this_month":"\u9019\u500b\u6708","this_week":"\u672c\u661f\u671f","thu":"\u9031\u56db","to":"\u5230","today":"\u4eca\u5929","too_long":"\u592a\u9577","too_short":"\u904e\u77ed","tue":"\u6cbb\u7642\u8cbb\u7528","valid_number":"\u6709\u6548\u7684","wed":"\u661f\u671f\u4e09","yes_delete":"\u662f\u7684\uff0c\u522a\u9664\uff01","yesterday":"\u6628\u5929"}});
})();
