<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{__('Service Unavailable')}}</title>
</head>
<style>
    @import url('https://fonts.googleapis.com/css?family=Roboto+Mono:300,500');

    html,
    .container > .row,
    .container > .row > div {
        height: 100%;
    }

    #countUp {
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        height: 100%;
    }
</style>
<body style="overflow:hidden">
<div class="container">
    <div class="row">
        <div class="xs-12 md-6 mx-auto">
            <div id="countUp" style="overflow-y: hidden">
                <svg  viewBox="0 0 500 500" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M58.8797 272.43C58.8797 272.43 58.3997 343.23 115.52 391.87C172.64 440.51 254.21 445.93 320.17 452.07C386.13 458.21 438.39 422 448.25 365.48C458.11 308.96 408.25 291.06 383.32 225.84C358.39 160.62 361.69 139.46 305.22 98.32C248.75 57.18 157 79.26 106.81 146.07C56.6197 212.88 58.8797 272.43 58.8797 272.43Z" fill="#0EA6E9"/>
                    <path opacity="0.7" d="M58.8797 272.43C58.8797 272.43 58.3997 343.23 115.52 391.87C172.64 440.51 254.21 445.93 320.17 452.07C386.13 458.21 438.39 422 448.25 365.48C458.11 308.96 408.25 291.06 383.32 225.84C358.39 160.62 361.69 139.46 305.22 98.32C248.75 57.18 157 79.26 106.81 146.07C56.6197 212.88 58.8797 272.43 58.8797 272.43Z" fill="white"/>
                    <path d="M396.65 263.73C393.951 262.345 391.723 260.19 390.248 257.538C388.774 254.887 388.118 251.857 388.365 248.833C388.613 245.809 389.751 242.926 391.636 240.549C393.522 238.172 396.07 236.408 398.959 235.479C401.847 234.55 404.946 234.499 407.864 235.331C410.782 236.164 413.387 237.843 415.35 240.156C417.313 242.47 418.547 245.313 418.894 248.327C419.241 251.342 418.686 254.391 417.3 257.09C416.381 258.883 415.118 260.477 413.582 261.781C412.047 263.085 410.269 264.073 408.352 264.69C406.434 265.307 404.413 265.539 402.405 265.375C400.398 265.21 398.442 264.651 396.65 263.73V263.73Z" fill="#263238"/>
                    <path d="M411.38 241.85L418.82 252.29C419.119 250.261 419.003 248.193 418.48 246.21L411.38 241.85Z" fill="#0EA6E9"/>
                    <path d="M395.78 236.94L413.46 261.88C414.928 260.66 416.153 259.174 417.07 257.5L402.24 234.82C399.955 235.034 397.748 235.758 395.78 236.94V236.94Z" fill="#0EA6E9"/>
                    <path d="M403.09 265.4L395.41 254.4L399.41 264.82C400.609 265.16 401.845 265.355 403.09 265.4V265.4Z" fill="#0EA6E9"/>
                    <path d="M409.33 264.32L391.77 240.39C391.6 240.6 391.44 240.83 391.28 241.05L404 265.42C405.828 265.371 407.633 264.999 409.33 264.32Z" fill="#0EA6E9"/>
                    <path d="M261.76 432.31C257.309 434.34 252.355 435.004 247.526 434.219C242.698 433.434 238.21 431.234 234.631 427.899C231.051 424.564 228.541 420.242 227.418 415.48C226.295 410.719 226.608 405.731 228.319 401.147C230.03 396.564 233.061 392.591 237.03 389.73C240.999 386.869 245.727 385.249 250.616 385.075C255.505 384.901 260.336 386.18 264.499 388.751C268.661 391.322 271.967 395.07 274 399.52C275.352 402.476 276.108 405.67 276.224 408.919C276.341 412.167 275.815 415.407 274.679 418.453C273.542 421.498 271.816 424.29 269.599 426.667C267.382 429.045 264.719 430.963 261.76 432.31V432.31Z" fill="#263238"/>
                    <path d="M273.78 420.5L256.9 394L276.07 412.42C276.12 411.91 276.16 411.42 276.18 410.88L253.47 385.14C251.529 384.979 249.574 385.053 247.65 385.36L252.21 392.61L244.67 386.01L250.67 396.87L238.54 388.73C238.24 388.92 237.94 389.11 237.65 389.31L260.16 414.31L242.3 400.72L248.65 410.72L239.4 404.32L263.62 431.38C266.568 429.733 269.145 427.497 271.19 424.81L266.26 416.58L272.38 423.1C272.901 422.263 273.368 421.395 273.78 420.5V420.5Z" fill="#0EA6E9"/>
                    <path d="M258.77 433.45L239.42 411.13L248.02 424.41L226.82 407.79C226.298 414.119 228.232 420.407 232.219 425.35C236.207 430.292 241.943 433.511 248.24 434.34L240.6 427.55L252.46 434.55C254.601 434.453 256.722 434.083 258.77 433.45Z" fill="#0EA6E9"/>
                    <path d="M260.689 386.87L271.539 399.47L269.339 394.66L272.849 397.36C270.082 392.603 265.801 388.91 260.689 386.87V386.87Z" fill="#0EA6E9"/>
                    <path d="M235.46 406.36L229.6 398.26C228.396 400.554 227.552 403.019 227.1 405.57L235.46 406.36Z" fill="#0EA6E9"/>
                    <path d="M288.23 393.36C286.43 389.42 278.45 388.87 267.85 391.28C268.523 391.872 269.161 392.503 269.76 393.17C277.68 391.35 283.33 391.51 284.5 394.05C286.56 398.56 273.71 408.86 255.79 417.05C237.87 425.24 221.69 428.24 219.62 423.73C218.56 421.41 221.47 417.55 226.98 413.23C226.854 412.352 226.777 411.467 226.75 410.58C219.06 416.58 214.97 422.42 216.66 426.1C219.51 432.34 237.85 430.1 257.66 421.03C277.47 411.96 291.08 399.6 288.23 393.36Z" fill="#263238"/>
                    <path d="M133.94 198.66C147.432 198.66 158.37 187.722 158.37 174.23C158.37 160.738 147.432 149.8 133.94 149.8C120.447 149.8 109.51 160.738 109.51 174.23C109.51 187.722 120.447 198.66 133.94 198.66Z" fill="#0EA6E9"/>
                    <path d="M139.7 156.16C141.339 154.657 143.232 153.455 145.29 152.61C143.307 151.562 141.186 150.798 138.99 150.34C136.726 151.85 134.574 153.521 132.55 155.34C123.81 163.28 126.19 162.49 113.49 167.25C112.318 167.683 111.19 168.225 110.12 168.87C109.718 170.618 109.514 172.406 109.51 174.2C109.512 177.282 110.099 180.336 111.24 183.2C115.78 181.82 121.82 179.58 124.61 176.79C129.37 172.05 130.17 164.9 139.7 156.16Z" fill="#263238"/>
                    <path d="M116.189 191C118.038 192.962 120.197 194.608 122.579 195.87C127.129 192.69 129.249 189.31 135.729 186.37C141.419 183.78 150.809 183.21 156.669 183.14C157.784 180.308 158.357 177.293 158.359 174.25C158.359 173.83 158.359 173.42 158.299 173C151.378 173.539 144.574 175.099 138.109 177.63C128.869 181.3 124.389 187.85 116.189 191Z" fill="#263238"/>
                    <path d="M140.49 165.69C144.81 167.85 151.49 166.69 156.64 165.25C155.652 162.764 154.263 160.457 152.53 158.42C145.65 159.71 134.51 162.7 140.49 165.69Z" fill="#263238"/>
                    <path d="M200.39 297.85C200.39 315.22 187.64 330.35 159.62 330.35C146.03 330.35 131.74 326.57 122.21 319.84L131.21 302.47C138.63 308.07 148.86 311.29 159.09 311.29C170.43 311.29 177.44 306.53 177.44 298.55C177.44 290.84 172.44 285.8 154.6 285.8H129.5L134.5 230.6H194.32V248.81H153.45L151.91 267.44H159.91C188.9 267.44 200.39 280.47 200.39 297.85ZM209.63 279.63C209.63 247.27 227.56 228.92 251.63 228.92C275.7 228.92 293.63 247.27 293.63 279.63C293.63 311.99 275.84 330.35 251.63 330.35C227.42 330.35 209.63 312 209.63 279.63ZM270.85 279.63C270.85 257.36 263.01 248.11 251.66 248.11C240.31 248.11 232.66 257.36 232.66 279.63C232.66 301.9 240.5 311.15 251.66 311.15C262.82 311.15 270.85 301.91 270.85 279.63ZM375.79 298.69C375.79 315.22 363.04 330.35 335.16 330.35C321.43 330.35 307.28 326.57 297.75 319.84L306.58 302.47C314.01 308.07 324.37 311.29 334.58 311.29C345.93 311.29 352.93 306.67 352.93 298.69C352.93 291.26 347.47 286.64 334.58 286.64H324.23V271.64L344.41 248.8H302.66V230.6H371.31V245.31L349.17 270.52C366.82 273.33 375.79 284.25 375.79 298.69Z" fill="#263238"/>
                    <path d="M325.24 82.79C324.751 82.0098 324.591 81.0676 324.796 80.1698C325 79.272 325.552 78.4918 326.33 78L332 74.41C332.387 74.1648 332.819 73.9984 333.271 73.9205C333.722 73.8425 334.185 73.8545 334.632 73.9558C335.079 74.0571 335.501 74.2456 335.875 74.5106C336.249 74.7756 336.567 75.1118 336.81 75.5V75.5C337.055 75.8871 337.222 76.3188 337.3 76.7704C337.378 77.222 337.366 77.6845 337.264 78.1314C337.163 78.5783 336.975 79.0009 336.71 79.3747C336.445 79.7486 336.108 80.0664 335.72 80.31L330.06 83.88C329.672 84.1255 329.24 84.292 328.787 84.3701C328.335 84.4482 327.872 84.4362 327.424 84.335C326.976 84.2337 326.553 84.0452 326.178 83.78C325.803 83.5149 325.485 83.1785 325.24 82.79V82.79Z" fill="white" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M322.16 107.29C319.479 103.464 316.144 100.14 312.31 97.47C307.29 94.4729 302.094 91.7813 296.75 89.41L293.52 71.41C296.614 68.4408 299.389 65.1563 301.8 61.61C304.72 56.9 303.8 53.74 301.93 50.48C300.06 47.22 297.47 49.33 297.08 50.82C296.793 52.3889 296.619 53.9763 296.56 55.57C296.56 55.57 294.82 43.57 293.81 40.84C292.8 38.11 288.95 40.74 289.29 41.65C289.29 41.65 288.13 38.24 285.74 38.2C283.35 38.16 282.67 42.2 282.67 42.2C282.67 42.2 279.6 40.78 277.88 42.56C276.16 44.34 276.98 48.8 276.98 48.8C276.98 48.8 274.24 49.8 273.82 53.69C273.4 57.58 273.74 64.39 274.82 66.26C275.375 67.1475 275.86 68.077 276.27 69.04C274.91 85.28 274.96 84.21 274.56 90.69C274.28 95.25 277.27 105.85 281.56 110.26C285.85 114.67 301.2 122.46 301.2 122.46C301.2 122.46 317.23 118.33 322.16 107.29Z" fill="white"/>
                    <path d="M301.26 122.48C301.26 122.48 317.26 118.33 322.16 107.29C322.16 107.29 321.84 106.82 321.27 106.07L317.11 102.6C311.203 103.095 305.335 103.967 299.54 105.21C290.76 107.21 283.93 102.93 281.33 93.21C278.73 83.49 276.33 69.1 276.33 69.1C274.97 85.34 275.02 84.27 274.62 90.75C274.34 95.31 277.33 105.91 281.62 110.32C285.91 114.73 301.26 122.48 301.26 122.48Z" fill="#0EA6E9"/>
                    <path opacity="0.5" d="M301.26 122.48C301.26 122.48 317.26 118.33 322.16 107.29C322.16 107.29 321.84 106.82 321.27 106.07L317.11 102.6C311.203 103.095 305.335 103.967 299.54 105.21C290.76 107.21 283.93 102.93 281.33 93.21C278.73 83.49 276.33 69.1 276.33 69.1C274.97 85.34 275.02 84.27 274.62 90.75C274.34 95.31 277.33 105.91 281.62 110.32C285.91 114.73 301.26 122.48 301.26 122.48Z" fill="white"/>
                    <path d="M322.16 107.29C319.479 103.464 316.144 100.14 312.31 97.47C307.29 94.4729 302.094 91.7813 296.75 89.41L293.52 71.41C296.614 68.4408 299.389 65.1563 301.8 61.61C304.72 56.9 303.8 53.74 301.93 50.48C300.06 47.22 297.47 49.33 297.08 50.82C296.793 52.3889 296.619 53.9763 296.56 55.57C296.56 55.57 294.82 43.57 293.81 40.84C292.8 38.11 288.95 40.74 289.29 41.65C289.29 41.65 288.13 38.24 285.74 38.2C283.35 38.16 282.67 42.2 282.67 42.2C282.67 42.2 279.6 40.78 277.88 42.56C276.16 44.34 276.98 48.8 276.98 48.8C276.98 48.8 274.24 49.8 273.82 53.69C273.4 57.58 273.74 64.39 274.82 66.26C275.375 67.1475 275.86 68.077 276.27 69.04C274.91 85.28 274.96 84.21 274.56 90.69C274.28 95.25 277.27 105.85 281.56 110.26C285.85 114.67 301.2 122.46 301.2 122.46C301.2 122.46 317.23 118.33 322.16 107.29Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M295.5 82.42L293.5 71.42C296.593 68.4508 299.369 65.1663 301.78 61.62C304.7 56.91 303.78 53.75 301.91 50.49C300.04 47.23 297.45 49.34 297.06 50.83C296.773 52.3989 296.599 53.9863 296.54 55.58C296.54 55.58 294.8 43.58 293.79 40.85C292.78 38.12 288.93 40.75 289.27 41.66C289.27 41.66 288.11 38.25 285.72 38.21C283.33 38.17 282.65 42.21 282.65 42.21C282.65 42.21 279.58 40.79 277.86 42.57C276.14 44.35 276.96 48.81 276.96 48.81C276.96 48.81 274.22 49.81 273.8 53.7C273.38 57.59 273.72 64.4 274.8 66.27C275.355 67.1575 275.839 68.087 276.25 69.05C275.65 76.23 275.32 80.05 275.11 82.59L295.5 82.42Z" fill="white" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M279.54 107.54C279.909 108.143 280.313 108.724 280.75 109.28C284.97 105.75 294.47 97.28 298.75 90.01C297.55 89.63 296.75 89.41 296.75 89.41C296.75 89.41 287.91 101 279.54 107.54Z" fill="white" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M296.559 55.55C296.559 55.55 287.109 55.2 286.109 63.17" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M289.29 41.63L289.61 51.68" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M282.67 42.22L283.32 51.31" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M276.979 48.82L277.999 54.49" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M291.509 51.21C291.509 51.21 280.839 53 276.729 56.49" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M289 114.24C292.48 111.24 292.21 105.24 288.38 100.75C284.69 96.43 279.04 95.16 275.52 97.75C276.71 102.35 278.89 107.51 281.59 110.26C283.559 112.054 285.707 113.642 288 115C288.359 114.782 288.694 114.528 289 114.24V114.24Z" fill="#0EA6E9"/>
                    <path d="M289 114.24C292.48 111.24 292.21 105.24 288.38 100.75C284.69 96.43 279.04 95.16 275.52 97.75C276.71 102.35 278.89 107.51 281.59 110.26C283.559 112.054 285.707 113.642 288 115C288.359 114.782 288.694 114.528 289 114.24V114.24Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M282.209 125.93C282.209 125.93 277.739 126.4 276.329 127.61C274.919 128.82 264.189 138 262.449 143.44C260.709 148.88 267.319 165.16 274.539 171.44C281.759 177.72 290.779 184.37 298.439 183C306.099 181.63 314.899 169.83 315.809 166.62C316.719 163.41 286.749 126.62 286.749 126.62C286.749 126.62 284.619 124.48 282.209 125.93Z" fill="white"/>
                    <path d="M282.21 125.93C282.21 125.93 281.33 126.02 280.21 126.23L281.21 127.92C281.21 127.92 280.29 137.4 286.79 148.14C293.29 158.88 304.68 165.7 304.35 169.6C304.02 173.5 305.35 178.71 295.57 178.06C285.79 177.41 275.41 160.82 271.83 152.69C269.97 148.46 268.37 142.04 266.54 137.07C264.776 138.921 263.365 141.08 262.38 143.44C260.64 148.88 267.25 165.16 274.47 171.44C281.69 177.72 290.71 184.37 298.37 183C306.03 181.63 314.83 169.83 315.74 166.62C316.65 163.41 286.68 126.62 286.68 126.62C286.68 126.62 284.62 124.48 282.21 125.93Z" fill="#0EA6E9"/>
                    <path opacity="0.5" d="M282.21 125.93C282.21 125.93 281.33 126.02 280.21 126.23L281.21 127.92C281.21 127.92 280.29 137.4 286.79 148.14C293.29 158.88 304.68 165.7 304.35 169.6C304.02 173.5 305.35 178.71 295.57 178.06C285.79 177.41 275.41 160.82 271.83 152.69C269.97 148.46 268.37 142.04 266.54 137.07C264.776 138.921 263.365 141.08 262.38 143.44C260.64 148.88 267.25 165.16 274.47 171.44C281.69 177.72 290.71 184.37 298.37 183C306.03 181.63 314.83 169.83 315.74 166.62C316.65 163.41 286.68 126.62 286.68 126.62C286.68 126.62 284.62 124.48 282.21 125.93Z" fill="white"/>
                    <path d="M282.209 125.93C282.209 125.93 277.739 126.4 276.329 127.61C274.919 128.82 264.189 138 262.449 143.44C260.709 148.88 267.319 165.16 274.539 171.44C281.759 177.72 290.779 184.37 298.439 183C306.099 181.63 314.899 169.83 315.809 166.62C316.719 163.41 286.749 126.62 286.749 126.62C286.749 126.62 284.619 124.48 282.209 125.93Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M320.389 104.12C320.389 104.12 315.649 102.52 308.589 105.52C301.529 108.52 283.869 118.89 281.279 127.92C279.569 133.85 298.279 161.54 309.969 166.1C313.109 167.32 315.969 168.65 322.399 163.41C328.829 158.17 342.309 143.62 345.839 137.21C349.369 130.8 343.839 126.02 341.989 123.21C340.139 120.4 325.349 102 320.389 104.12Z" fill="white"/>
                    <path d="M345.88 137.12L333.69 141C333.69 141 321.01 156 316.46 159.87C311.91 163.74 297.59 154.34 292.71 149.78L291.27 148.44C297.1 156.36 304.35 163.92 309.97 166.12C313.11 167.34 315.97 168.67 322.4 163.43C328.83 158.19 342.31 143.64 345.84 137.23C345.859 137.196 345.872 137.159 345.88 137.12Z" fill="#0EA6E9"/>
                    <path d="M339.55 135.78L346.11 136.63C349.02 130.51 343.82 125.93 341.99 123.19C340.16 120.45 325.35 102 320.39 104.12C319.481 103.865 318.544 103.727 317.6 103.71C311.6 108.23 312.28 113.42 317.76 122.77C323.24 132.12 339.55 135.78 339.55 135.78Z" fill="#0EA6E9"/>
                    <g opacity="0.5">
                        <path opacity="0.5" d="M345.88 137.12L333.69 141C333.69 141 321.01 156 316.46 159.87C311.91 163.74 297.59 154.34 292.71 149.78L291.27 148.44C297.1 156.36 304.35 163.92 309.97 166.12C313.11 167.34 315.97 168.67 322.4 163.43C328.83 158.19 342.31 143.64 345.84 137.23C345.859 137.196 345.872 137.159 345.88 137.12Z" fill="white"/>
                        <path opacity="0.5" d="M339.55 135.78L346.11 136.63C349.02 130.51 343.82 125.93 341.99 123.19C340.16 120.45 325.35 102 320.39 104.12C319.481 103.865 318.544 103.727 317.6 103.71C311.6 108.23 312.28 113.42 317.76 122.77C323.24 132.12 339.55 135.78 339.55 135.78Z" fill="white"/>
                    </g>
                    <path d="M320.389 104.12C320.389 104.12 315.649 102.52 308.589 105.52C301.529 108.52 283.869 118.89 281.279 127.92C279.569 133.85 298.279 161.54 309.969 166.1C313.109 167.32 315.969 168.65 322.399 163.41C328.829 158.17 342.309 143.62 345.839 137.21C349.369 130.8 343.839 126.02 341.989 123.21C340.139 120.4 325.349 102 320.389 104.12Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M325.711 131.539L313.589 114.909C311.673 112.28 307.988 111.702 305.359 113.618L292.559 122.949C289.931 124.865 289.353 128.55 291.269 131.178L303.392 147.809C305.308 150.438 308.992 151.015 311.621 149.099L324.421 139.768C327.05 137.852 327.628 134.168 325.711 131.539Z" fill="white" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M479.52 230.22C464.57 191.22 427.17 191.65 394.18 192.06C382.81 192.2 372.07 192.34 362.18 191.06C328.81 186.84 319.27 152.54 319.18 152.06C319.1 151.757 318.961 151.473 318.771 151.224C318.581 150.975 318.344 150.766 318.073 150.609C317.803 150.451 317.504 150.349 317.193 150.307C316.883 150.265 316.567 150.285 316.265 150.365C315.962 150.445 315.678 150.584 315.429 150.774C315.18 150.964 314.971 151.201 314.814 151.471C314.656 151.742 314.554 152.041 314.512 152.351C314.47 152.662 314.49 152.977 314.57 153.28C314.67 153.66 324.96 191.12 361.57 195.76C371.8 197.06 383.21 196.91 394.25 196.76C427.25 196.35 461.31 195.92 475.08 231.85C478.151 240.144 478.941 249.11 477.366 257.813C475.792 266.516 471.912 274.637 466.13 281.33C455.89 293.12 441.36 297.9 426.28 294.44C412.05 291.17 397.99 286.67 384.39 282.32C361.88 275.12 338.61 267.67 313.91 265.6C271.56 262.04 242.1 282.67 208.02 306.54C201.16 311.35 194.07 316.31 186.64 321.25L182.41 324.07C161.32 338.15 139.52 352.71 114.85 355.34C95.6698 357.34 76.1698 348.4 66.2998 332.99C63.5579 328.8 61.6773 324.107 60.7673 319.183C59.8574 314.259 59.9364 309.203 60.9998 304.31C61.9839 300.074 63.8275 296.086 66.4164 292.593C69.0052 289.099 72.2841 286.174 76.0498 284C88.8198 276.39 111.38 273.86 130.62 276L130.95 271.25C110.76 269.1 87.1998 271.86 73.6098 279.95C69.3055 282.474 65.5576 285.844 62.5927 289.858C59.6278 293.871 57.5075 298.444 56.3598 303.3C55.1378 308.826 55.032 314.54 56.0486 320.107C57.0652 325.675 59.1837 330.983 62.2798 335.72C72.1798 351.19 90.0898 360.54 109.1 360.57C111.187 360.569 113.274 360.459 115.35 360.24C141.18 357.49 164.49 341.93 185.04 328.24L189.26 325.42C196.75 320.42 203.86 315.42 210.74 310.65C244.07 287.3 272.85 267.13 313.5 270.55C337.66 272.55 360.67 279.94 382.92 287.06C396.62 291.44 410.78 295.97 425.2 299.28C442.06 303.15 458.28 297.82 469.72 284.66C476.088 277.3 480.358 268.362 482.083 258.783C483.807 249.205 482.922 239.339 479.52 230.22V230.22Z" fill="white" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M313.399 121.06C313.399 121.703 313.209 122.331 312.852 122.866C312.495 123.4 311.987 123.817 311.393 124.063C310.799 124.309 310.146 124.373 309.515 124.248C308.885 124.122 308.306 123.813 307.851 123.358C307.397 122.904 307.087 122.324 306.962 121.694C306.836 121.064 306.901 120.41 307.147 119.816C307.393 119.222 307.809 118.715 308.344 118.358C308.878 118.001 309.507 117.81 310.149 117.81C311.011 117.81 311.838 118.152 312.448 118.762C313.057 119.371 313.399 120.198 313.399 121.06V121.06Z" fill="#0EA6E9" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M304.58 128.48C304.582 129.124 304.393 129.753 304.037 130.289C303.68 130.825 303.173 131.243 302.578 131.491C301.984 131.738 301.33 131.803 300.698 131.678C300.067 131.553 299.487 131.243 299.032 130.788C298.577 130.333 298.267 129.753 298.142 129.122C298.017 128.49 298.082 127.836 298.329 127.242C298.577 126.647 298.995 126.14 299.531 125.784C300.067 125.427 300.696 125.238 301.34 125.24C302.199 125.24 303.023 125.581 303.631 126.189C304.239 126.797 304.58 127.621 304.58 128.48V128.48Z" fill="#0EA6E9" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M349.328 129.27C363.382 125.187 371.466 110.484 367.383 96.4294C363.299 82.375 348.596 74.2917 334.542 78.3749C320.487 82.4581 312.404 97.1615 316.487 111.216C320.57 125.27 335.274 133.354 349.328 129.27Z" fill="white"/>
                    <path d="M362.07 86.59C361.15 85.5128 360.147 84.5097 359.07 83.59C360.629 89.0546 360.387 94.8757 358.382 100.192C356.376 105.509 352.713 110.04 347.933 113.113C343.154 116.187 337.512 117.641 331.842 117.261C326.173 116.88 320.776 114.685 316.45 111C317.524 114.814 319.441 118.339 322.058 121.314C324.675 124.289 327.926 126.64 331.572 128.192C335.218 129.744 339.166 130.458 343.124 130.282C347.083 130.107 350.952 129.045 354.446 127.175C357.94 125.306 360.969 122.676 363.312 119.48C365.655 116.285 367.251 112.604 367.983 108.71C368.714 104.815 368.563 100.806 367.54 96.978C366.516 93.1498 364.647 89.6 362.07 86.59Z" fill="#0EA6E9"/>
                    <path opacity="0.5" d="M362.07 86.59C361.15 85.5128 360.147 84.5097 359.07 83.59C360.629 89.0546 360.387 94.8757 358.382 100.192C356.376 105.509 352.713 110.04 347.933 113.113C343.154 116.187 337.512 117.641 331.842 117.261C326.173 116.88 320.776 114.685 316.45 111C317.524 114.814 319.441 118.339 322.058 121.314C324.675 124.289 327.926 126.64 331.572 128.192C335.218 129.744 339.166 130.458 343.124 130.282C347.083 130.107 350.952 129.045 354.446 127.175C357.94 125.306 360.969 122.676 363.312 119.48C365.655 116.285 367.251 112.604 367.983 108.71C368.714 104.815 368.563 100.806 367.54 96.978C366.516 93.1498 364.647 89.6 362.07 86.59Z" fill="white"/>
                    <path d="M349.328 129.27C363.382 125.187 371.466 110.484 367.383 96.4294C363.299 82.375 348.596 74.2917 334.542 78.3749C320.487 82.4581 312.404 97.1615 316.487 111.216C320.57 125.27 335.274 133.354 349.328 129.27Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M365.46 122.13L373.18 115.53" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M375.229 116.36C375.64 116.009 375.895 115.508 375.937 114.969C375.98 114.43 375.806 113.896 375.454 113.485C375.103 113.074 374.603 112.819 374.063 112.777C373.524 112.735 372.99 112.909 372.579 113.26C372.376 113.434 372.209 113.646 372.087 113.885C371.966 114.124 371.892 114.384 371.871 114.651C371.829 115.19 372.003 115.724 372.354 116.135C372.706 116.546 373.206 116.801 373.745 116.843C374.284 116.885 374.818 116.711 375.229 116.36V116.36Z" fill="#263238"/>
                    <path d="M356 130.13C355.703 129.782 355.477 129.379 355.336 128.944C355.195 128.509 355.141 128.05 355.177 127.594C355.213 127.138 355.339 126.694 355.547 126.286C355.755 125.879 356.042 125.517 356.39 125.22L361.47 120.86C362.175 120.262 363.089 119.967 364.01 120.04C364.932 120.113 365.788 120.548 366.39 121.25V121.25C366.688 121.597 366.914 122 367.056 122.434C367.198 122.869 367.253 123.328 367.218 123.784C367.183 124.24 367.058 124.684 366.85 125.092C366.643 125.5 366.358 125.863 366.01 126.16L360.92 130.52C360.216 131.121 359.302 131.417 358.379 131.344C357.457 131.271 356.601 130.834 356 130.13Z" fill="white" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M347.71 134.5C347.71 134.5 337.42 131.72 333.37 139.45C329.32 147.18 333.89 166.45 333.89 166.45C333.89 166.45 326.37 178.67 324.46 180C322.55 181.33 317.17 180.75 311.87 183.45C306.57 186.15 308.32 188.92 309.73 189.85C311.14 190.78 315.46 188 316.73 188.1C318 188.2 317.86 190.49 312.86 195.68C307.86 200.87 305.57 201 307 203.4C307.388 204.087 307.985 204.631 308.705 204.953C309.425 205.275 310.229 205.358 311 205.19C310.824 205.785 310.868 206.423 311.125 206.987C311.383 207.551 311.835 208.003 312.4 208.26C314.46 209.26 315.34 208.49 315.34 208.49C315.34 208.49 315.14 211.1 317.05 211.9C318.548 212.341 320.142 212.341 321.64 211.9C321.64 211.9 323.45 214.02 325.28 213.67C327.11 213.32 331.28 208.22 334.58 203.88C337.88 199.54 350.58 184.11 355.58 174.65C360.58 165.19 358.21 155.65 357.19 149.82C356.17 143.99 351.55 135.78 347.71 134.5Z" fill="white"/>
                    <path d="M357.19 149.85C356.19 144.02 351.55 135.78 347.71 134.5L347.47 134.44C350.988 142.878 352.398 152.045 351.58 161.15C350.28 177.73 335.07 190.81 330.44 195.62C326.73 199.48 322.06 204.89 315.33 208.89C315.304 209.5 315.451 210.105 315.754 210.636C316.056 211.166 316.502 211.601 317.04 211.89C318.538 212.331 320.132 212.331 321.63 211.89C321.63 211.89 323.44 214.01 325.27 213.66C327.1 213.31 331.27 208.21 334.57 203.87C337.87 199.53 350.57 184.1 355.57 174.64C360.57 165.18 358.21 155.68 357.19 149.85Z" fill="#0EA6E9"/>
                    <path opacity="0.5" d="M357.19 149.85C356.19 144.02 351.55 135.78 347.71 134.5L347.47 134.44C350.988 142.878 352.398 152.045 351.58 161.15C350.28 177.73 335.07 190.81 330.44 195.62C326.73 199.48 322.06 204.89 315.33 208.89C315.304 209.5 315.451 210.105 315.754 210.636C316.056 211.166 316.502 211.601 317.04 211.89C318.538 212.331 320.132 212.331 321.63 211.89C321.63 211.89 323.44 214.01 325.27 213.66C327.1 213.31 331.27 208.21 334.57 203.87C337.87 199.53 350.57 184.1 355.57 174.64C360.57 165.18 358.21 155.68 357.19 149.85Z" fill="white"/>
                    <path d="M347.71 134.5C347.71 134.5 337.42 131.72 333.37 139.45C329.32 147.18 333.89 166.45 333.89 166.45C333.89 166.45 326.37 178.67 324.46 180C322.55 181.33 317.17 180.75 311.87 183.45C306.57 186.15 308.32 188.92 309.73 189.85C311.14 190.78 315.46 188 316.73 188.1C318 188.2 317.86 190.49 312.86 195.68C307.86 200.87 305.57 201 307 203.4C307.388 204.087 307.985 204.631 308.705 204.953C309.425 205.275 310.229 205.358 311 205.19C310.824 205.785 310.868 206.423 311.125 206.987C311.383 207.551 311.835 208.003 312.4 208.26C314.46 209.26 315.34 208.49 315.34 208.49C315.34 208.49 315.14 211.1 317.05 211.9C318.548 212.341 320.142 212.341 321.64 211.9C321.64 211.9 323.45 214.02 325.28 213.67C327.11 213.32 331.28 208.22 334.58 203.88C337.88 199.54 350.58 184.11 355.58 174.65C360.58 165.19 358.21 155.65 357.19 149.82C356.17 143.99 351.55 135.78 347.71 134.5Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M325.27 213.7C327.1 213.35 331.27 208.25 334.57 203.91C336.44 201.46 341.32 195.45 346.11 188.98C342.9 177.98 333.4 174.69 329.17 173.78C327.26 176.64 325.3 179.38 324.46 179.97C322.55 181.3 317.17 180.72 311.87 183.42C306.57 186.12 308.32 188.89 309.73 189.82C311.14 190.75 315.46 187.97 316.73 188.07C318 188.17 317.86 190.46 312.86 195.65C307.86 200.84 305.57 201 307 203.4C307.388 204.087 307.985 204.631 308.705 204.953C309.425 205.275 310.229 205.358 311 205.19C310.824 205.785 310.868 206.423 311.125 206.987C311.383 207.551 311.835 208.003 312.4 208.26C314.46 209.26 315.34 208.49 315.34 208.49C315.34 208.49 315.14 211.1 317.05 211.9C318.548 212.341 320.142 212.341 321.64 211.9C321.64 211.9 323.44 214.05 325.27 213.7Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M311 205.19C314.809 203.213 318.203 200.525 321 197.27" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M315.33 208.49C319.333 206.545 322.898 203.806 325.81 200.44" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M321.63 211.93C321.63 211.93 327.39 207.62 330.13 204.06" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M357.65 169.44C357.86 168.68 358.02 167.92 358.16 167.17C349.78 161.58 339.22 163.41 333.59 165.04C333.77 165.91 333.89 166.42 333.89 166.42L333.02 167.82C346.48 164.57 353.9 167 357.65 169.44Z" fill="white" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M351.809 174.55C352.554 175.419 353.44 176.156 354.429 176.73C354.839 176.02 355.229 175.34 355.579 174.73C358.128 169.707 359.144 164.046 358.499 158.45C356.377 158.543 354.346 159.342 352.729 160.72C350.783 162.438 349.593 164.855 349.421 167.446C349.249 170.036 350.107 172.59 351.809 174.55V174.55Z" fill="#0EA6E9" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M257.06 138.09C257.06 138.09 261.22 150.09 266.57 150.98C271.92 151.87 279.36 142.79 280.87 135.98C282.38 129.17 277.07 123.69 269.39 116.85C261.71 110.01 250.7 106.03 241.39 111.22C232.08 116.41 218.32 131.22 218.32 131.22C218.32 131.22 209.71 123.65 205.14 127.56C200.57 131.47 206.53 143.43 210.74 148.36C214.95 153.29 222.63 160.52 230 158.8C237.37 157.08 243.21 143.25 248 139.18C252.79 135.11 256 136.86 257.06 138.09Z" fill="white"/>
                    <path d="M269 141C260.87 137.1 263.15 127.34 255 124.74C246.85 122.14 247.52 127.67 241 138.08C234.48 148.49 222.46 147.83 214.33 145.23C211.753 144.396 209.22 143.431 206.74 142.34C207.852 144.514 209.193 146.562 210.74 148.45C214.95 153.38 222.6 160.54 229.96 158.82C237.32 157.1 243.17 143.27 247.96 139.2C252.75 135.13 256.02 136.88 257.07 138.11C257.07 138.11 261.23 150.11 266.58 151C271.93 151.89 279.37 142.81 280.88 136C281.131 134.885 281.195 133.736 281.07 132.6L280.69 132.52C280.69 132.52 277.1 144.89 269 141Z" fill="#0EA6E9"/>
                    <path opacity="0.5" d="M269 141C260.87 137.1 263.15 127.34 255 124.74C246.85 122.14 247.52 127.67 241 138.08C234.48 148.49 222.46 147.83 214.33 145.23C211.753 144.396 209.22 143.431 206.74 142.34C207.852 144.514 209.193 146.562 210.74 148.45C214.95 153.38 222.6 160.54 229.96 158.82C237.32 157.1 243.17 143.27 247.96 139.2C252.75 135.13 256.02 136.88 257.07 138.11C257.07 138.11 261.23 150.11 266.58 151C271.93 151.89 279.37 142.81 280.88 136C281.131 134.885 281.195 133.736 281.07 132.6L280.69 132.52C280.69 132.52 277.1 144.89 269 141Z" fill="white"/>
                    <path d="M257.06 138.09C257.06 138.09 261.22 150.09 266.57 150.98C271.92 151.87 279.36 142.79 280.87 135.98C282.38 129.17 277.07 123.69 269.39 116.85C261.71 110.01 250.7 106.03 241.39 111.22C232.08 116.41 218.32 131.22 218.32 131.22C218.32 131.22 209.71 123.65 205.14 127.56C200.57 131.47 206.53 143.43 210.74 148.36C214.95 153.29 222.63 160.52 230 158.8C237.37 157.08 243.21 143.25 248 139.18C252.79 135.11 256 136.86 257.06 138.09Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M230.83 119.18C224.19 125 218.35 131.29 218.35 131.29C218.35 131.29 209.74 123.72 205.17 127.63C200.6 131.54 206.56 143.5 210.77 148.43C214.98 153.36 222.63 160.52 230 158.8C236.64 157.25 242 145.8 246.52 140.65C240.242 134.322 234.953 127.084 230.83 119.18V119.18Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M253 109C252.183 108.905 251.362 108.855 250.54 108.85C252.983 117.975 253.541 127.502 252.18 136.85C252.979 136.636 253.816 136.602 254.63 136.75C255.18 129.66 255.59 117.91 253 109Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M258.61 124.58C257.285 125.705 255.657 126.412 253.93 126.612C252.204 126.812 250.457 126.496 248.91 125.703C247.364 124.911 246.087 123.678 245.241 122.159C244.395 120.641 244.018 118.906 244.157 117.174C244.297 115.442 244.947 113.79 246.025 112.427C247.104 111.064 248.562 110.051 250.216 109.517C251.869 108.982 253.644 108.95 255.316 109.424C256.988 109.898 258.482 110.857 259.61 112.18C260.359 113.059 260.928 114.078 261.283 115.178C261.638 116.277 261.773 117.436 261.68 118.587C261.588 119.739 261.269 120.861 260.742 121.889C260.215 122.918 259.49 123.832 258.61 124.58V124.58Z" fill="#0EA6E9" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M230 158.8C231.751 158.306 233.352 157.385 234.66 156.12C229.95 156.9 221.25 156.64 213.34 147.12C205.64 137.88 205.51 130.69 206.27 126.91C205.878 127.091 205.511 127.323 205.18 127.6C200.6 131.51 206.57 143.47 210.78 148.4C214.99 153.33 222.63 160.52 230 158.8Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M281.129 180.59C281.129 180.59 293.299 184.17 297.129 180.35C300.959 176.53 301.529 164.92 293.249 160C287.249 156.46 281.039 156 271.009 158.24C260.979 160.48 251.349 167.17 250.179 177.73C249.009 188.29 253.079 208.15 253.079 208.15C253.079 208.15 241.929 210.76 242.449 216.76C242.969 222.76 256.179 224.85 262.629 224.28C269.079 223.71 279.369 221.65 282.239 214.66C285.109 207.67 277.239 194.88 276.699 188.66C276.159 182.44 279.519 180.73 281.129 180.59Z" fill="white"/>
                    <path d="M281.13 180.59C281.13 180.59 293.3 184.17 297.13 180.35C299.63 177.86 300.72 172.09 298.91 167C298.91 167 299.91 172.21 292.73 173.51C285.55 174.81 273.87 172.21 268.67 178.71C263.47 185.21 270.94 198.55 271.59 207.33C272.24 216.11 270.27 219 261.49 220C252.71 221 244.86 214.7 243.05 218.52C245.74 223.15 256.88 224.77 262.65 224.26C269.11 223.69 279.39 221.63 282.26 214.64C285.13 207.65 277.26 194.86 276.72 188.64C276.18 182.42 279.52 180.73 281.13 180.59Z" fill="#0EA6E9"/>
                    <path opacity="0.5" d="M281.13 180.59C281.13 180.59 293.3 184.17 297.13 180.35C299.63 177.86 300.72 172.09 298.91 167C298.91 167 299.91 172.21 292.73 173.51C285.55 174.81 273.87 172.21 268.67 178.71C263.47 185.21 270.94 198.55 271.59 207.33C272.24 216.11 270.27 219 261.49 220C252.71 221 244.86 214.7 243.05 218.52C245.74 223.15 256.88 224.77 262.65 224.26C269.11 223.69 279.39 221.63 282.26 214.64C285.13 207.65 277.26 194.86 276.72 188.64C276.18 182.42 279.52 180.73 281.13 180.59Z" fill="white"/>
                    <path d="M281.129 180.59C281.129 180.59 293.299 184.17 297.129 180.35C300.959 176.53 301.529 164.92 293.249 160C287.249 156.46 281.039 156 271.009 158.24C260.979 160.48 251.349 167.17 250.179 177.73C249.009 188.29 253.079 208.15 253.079 208.15C253.079 208.15 241.929 210.76 242.449 216.76C242.969 222.76 256.179 224.85 262.629 224.28C269.079 223.71 279.369 221.65 282.239 214.66C285.109 207.67 277.239 194.88 276.699 188.66C276.159 182.44 279.519 180.73 281.129 180.59Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M250.5 191C251.38 199.79 253.1 208.19 253.1 208.19C253.1 208.19 241.95 210.8 242.47 216.8C242.99 222.8 256.2 224.89 262.65 224.32C269.1 223.75 279.39 221.69 282.26 214.7C284.85 208.39 278.72 197.38 277.08 190.7C268.285 192.137 259.324 192.238 250.5 191V191Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M255.08 167.06C254.531 167.667 254.017 168.305 253.54 168.97C262.369 172.289 270.434 177.361 277.25 183.88C277.546 183.124 278.003 182.441 278.59 181.88C273.18 177.23 263.85 170.07 255.08 167.06Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M264.909 180.667C269.545 179.209 272.121 174.268 270.663 169.632C269.205 164.996 264.264 162.42 259.628 163.878C254.992 165.336 252.416 170.277 253.874 174.913C255.332 179.549 260.272 182.125 264.909 180.667Z" fill="#0EA6E9" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M282.26 214.66C282.877 212.948 283.056 211.109 282.78 209.31C280.68 213.6 275.42 220.53 263.1 221.45C251.1 222.35 245.17 218.28 242.55 215.45C242.462 215.874 242.435 216.308 242.47 216.74C243 222.74 256.2 224.83 262.65 224.26C269.1 223.69 279.39 221.65 282.26 214.66Z" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M350.87 92.66C348.229 89.1911 345.833 85.5422 343.7 81.74C339.224 81.1397 334.67 81.895 330.627 83.9083C326.584 85.9216 323.238 89.1005 321.02 93.0347C318.802 96.9688 317.814 101.478 318.183 105.979C318.553 110.48 320.263 114.767 323.094 118.287C325.924 121.806 329.745 124.396 334.062 125.723C338.379 127.05 342.994 127.052 347.313 125.729C351.631 124.407 355.454 121.82 358.288 118.303C361.121 114.786 362.836 110.501 363.21 106C358.663 101.975 354.529 97.506 350.87 92.66V92.66Z" fill="#263238" stroke="#263238" stroke-width="1.19148" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M353.059 113.17C352.017 114.187 350.693 114.868 349.259 115.123C347.825 115.377 346.348 115.195 345.019 114.599C343.69 114.003 342.57 113.022 341.807 111.782C341.043 110.541 340.67 109.1 340.736 107.645C340.802 106.19 341.304 104.789 342.177 103.623C343.05 102.457 344.254 101.581 345.631 101.108C347.009 100.635 348.497 100.587 349.902 100.971C351.307 101.355 352.564 102.152 353.509 103.26C354.132 103.939 354.615 104.735 354.93 105.601C355.244 106.468 355.385 107.388 355.343 108.308C355.301 109.229 355.078 110.133 354.686 110.967C354.294 111.801 353.741 112.55 353.059 113.17V113.17Z" fill="white"/>
                    <path d="M345.629 96.42C345.307 96.7048 344.908 96.8869 344.481 96.943C344.055 96.9992 343.622 96.9269 343.237 96.7353C342.852 96.5438 342.533 96.2417 342.321 95.8678C342.108 95.4939 342.013 95.0651 342.045 94.6364C342.078 94.2077 342.238 93.7986 342.505 93.4614C342.772 93.1242 343.133 92.8743 343.543 92.7437C343.952 92.613 344.392 92.6076 344.804 92.7281C345.217 92.8486 345.584 93.0895 345.859 93.42C346.221 93.8508 346.4 94.4061 346.357 94.967C346.314 95.5278 346.053 96.0494 345.629 96.42V96.42Z" fill="white"/>
                    <path d="M132.059 268.878L125.64 268.246L124.727 277.521L131.146 278.153L132.059 268.878Z" fill="#263238"/>
                    <path d="M166.052 362.014L167.466 362L169.818 354.146L172.086 362H173.514L176.342 352.242H174.97L172.828 360.488L170.588 352.242H169.16L166.808 360.516L164.68 352.242H163.322L166.052 362.014ZM180.998 355.28C182.314 355.28 183.434 356.106 183.42 357.604H178.576C178.716 356.106 179.752 355.28 180.998 355.28ZM184.582 359.634H183.21C182.93 360.46 182.202 361.048 181.054 361.048C179.752 361.048 178.66 360.194 178.562 358.64H184.694C184.722 358.374 184.736 358.15 184.736 357.87C184.736 355.77 183.28 354.202 181.054 354.202C178.814 354.202 177.26 355.728 177.26 358.15C177.26 360.586 178.87 362.126 181.054 362.126C182.958 362.126 184.19 361.034 184.582 359.634ZM189.674 358.136C189.674 360.516 191.256 362.126 193.3 362.126C194.714 362.126 195.708 361.398 196.17 360.572V362H197.458V354.328H196.17V355.728C195.722 354.93 194.742 354.202 193.314 354.202C191.256 354.202 189.674 355.742 189.674 358.136ZM196.17 358.15C196.17 359.956 194.966 361.006 193.566 361.006C192.166 361.006 190.976 359.942 190.976 358.136C190.976 356.33 192.166 355.308 193.566 355.308C194.966 355.308 196.17 356.372 196.17 358.15ZM200.885 357.828C200.885 356.05 201.809 355.504 203.027 355.504H203.363V354.188C202.145 354.188 201.319 354.72 200.885 355.574V354.328H199.611V362H200.885V357.828ZM208.096 355.28C209.412 355.28 210.532 356.106 210.518 357.604H205.674C205.814 356.106 206.85 355.28 208.096 355.28ZM211.68 359.634H210.308C210.028 360.46 209.3 361.048 208.152 361.048C206.85 361.048 205.758 360.194 205.66 358.64H211.792C211.82 358.374 211.834 358.15 211.834 357.87C211.834 355.77 210.378 354.202 208.152 354.202C205.912 354.202 204.358 355.728 204.358 358.15C204.358 360.586 205.968 362.126 208.152 362.126C210.056 362.126 211.288 361.034 211.68 359.634ZM224.052 354.328H222.778V358.542C222.778 360.194 221.896 361.006 220.58 361.006C219.292 361.006 218.438 360.208 218.438 358.654V354.328H217.178V358.822C217.178 361.02 218.564 362.112 220.328 362.112C221.35 362.112 222.288 361.664 222.778 360.866V362H224.052V354.328ZM231.817 362H233.077V357.478C233.077 355.28 231.719 354.188 229.941 354.188C228.905 354.188 227.981 354.622 227.477 355.42V354.328H226.203V362H227.477V357.758C227.477 356.106 228.373 355.294 229.675 355.294C230.963 355.294 231.817 356.092 231.817 357.66V362ZM234.682 358.136C234.682 360.516 236.264 362.126 238.322 362.126C239.722 362.126 240.716 361.412 241.178 360.558V362H242.466V351.64H241.178V355.7C240.646 354.818 239.54 354.202 238.336 354.202C236.264 354.202 234.682 355.742 234.682 358.136ZM241.178 358.15C241.178 359.956 239.974 361.006 238.574 361.006C237.174 361.006 235.984 359.942 235.984 358.136C235.984 356.33 237.174 355.308 238.574 355.308C239.974 355.308 241.178 356.372 241.178 358.15ZM247.881 355.28C249.197 355.28 250.317 356.106 250.303 357.604H245.459C245.599 356.106 246.635 355.28 247.881 355.28ZM251.465 359.634H250.093C249.813 360.46 249.085 361.048 247.937 361.048C246.635 361.048 245.543 360.194 245.445 358.64H251.577C251.605 358.374 251.619 358.15 251.619 357.87C251.619 355.77 250.163 354.202 247.937 354.202C245.697 354.202 244.143 355.728 244.143 358.15C244.143 360.586 245.753 362.126 247.937 362.126C249.841 362.126 251.073 361.034 251.465 359.634ZM254.575 357.828C254.575 356.05 255.499 355.504 256.717 355.504H257.053V354.188C255.835 354.188 255.009 354.72 254.575 355.574V354.328H253.301V362H254.575V357.828ZM273.33 362H274.59V357.478C274.59 355.28 273.232 354.188 271.482 354.188C270.306 354.188 269.214 354.79 268.766 355.896C268.262 354.748 267.212 354.188 265.952 354.188C264.944 354.188 264.034 354.622 263.53 355.434V354.328H262.256V362H263.53V357.772C263.53 356.12 264.412 355.294 265.7 355.294C266.96 355.294 267.8 356.092 267.8 357.66V362H269.06V357.772C269.06 356.12 269.942 355.294 271.23 355.294C272.49 355.294 273.33 356.092 273.33 357.66V362ZM276.204 358.136C276.204 360.516 277.786 362.126 279.83 362.126C281.244 362.126 282.238 361.398 282.7 360.572V362H283.988V354.328H282.7V355.728C282.252 354.93 281.272 354.202 279.844 354.202C277.786 354.202 276.204 355.742 276.204 358.136ZM282.7 358.15C282.7 359.956 281.496 361.006 280.096 361.006C278.696 361.006 277.506 359.942 277.506 358.136C277.506 356.33 278.696 355.308 280.096 355.308C281.496 355.308 282.7 356.372 282.7 358.15ZM286.141 362H287.415V354.328H286.141V362ZM286.799 353.082C287.261 353.082 287.639 352.704 287.639 352.214C287.639 351.724 287.261 351.346 286.799 351.346C286.309 351.346 285.931 351.724 285.931 352.214C285.931 352.704 286.309 353.082 286.799 353.082ZM295.2 362H296.46V357.478C296.46 355.28 295.102 354.188 293.324 354.188C292.288 354.188 291.364 354.622 290.86 355.42V354.328H289.586V362H290.86V357.758C290.86 356.106 291.756 355.294 293.058 355.294C294.346 355.294 295.2 356.092 295.2 357.66V362ZM298.821 359.9C298.821 361.44 299.591 362 300.949 362H302.097V360.922H301.159C300.375 360.922 300.095 360.656 300.095 359.9V355.378H302.097V354.328H300.095V352.396H298.821V354.328H297.827V355.378H298.821V359.9ZM306.903 355.28C308.219 355.28 309.339 356.106 309.325 357.604H304.481C304.62 356.106 305.657 355.28 306.903 355.28ZM310.487 359.634H309.115C308.835 360.46 308.107 361.048 306.959 361.048C305.657 361.048 304.565 360.194 304.467 358.64H310.599C310.627 358.374 310.641 358.15 310.641 357.87C310.641 355.77 309.185 354.202 306.959 354.202C304.719 354.202 303.165 355.728 303.165 358.15C303.165 360.586 304.775 362.126 306.959 362.126C308.863 362.126 310.095 361.034 310.487 359.634ZM317.936 362H319.196V357.478C319.196 355.28 317.838 354.188 316.06 354.188C315.024 354.188 314.1 354.622 313.596 355.42V354.328H312.322V362H313.596V357.758C313.596 356.106 314.492 355.294 315.794 355.294C317.082 355.294 317.936 356.092 317.936 357.66V362ZM320.801 358.136C320.801 360.516 322.383 362.126 324.427 362.126C325.841 362.126 326.835 361.398 327.297 360.572V362H328.585V354.328H327.297V355.728C326.849 354.93 325.869 354.202 324.441 354.202C322.383 354.202 320.801 355.742 320.801 358.136ZM327.297 358.15C327.297 359.956 326.093 361.006 324.693 361.006C323.293 361.006 322.103 359.942 322.103 358.136C322.103 356.33 323.293 355.308 324.693 355.308C326.093 355.308 327.297 356.372 327.297 358.15ZM336.352 362H337.612V357.478C337.612 355.28 336.254 354.188 334.476 354.188C333.44 354.188 332.516 354.622 332.012 355.42V354.328H330.738V362H332.012V357.758C332.012 356.106 332.908 355.294 334.21 355.294C335.498 355.294 336.352 356.092 336.352 357.66V362ZM339.217 358.15C339.217 360.586 340.771 362.126 342.955 362.126C344.859 362.126 346.105 361.062 346.497 359.536H345.125C344.845 360.502 344.089 361.048 342.955 361.048C341.555 361.048 340.519 360.054 340.519 358.15C340.519 356.274 341.555 355.28 342.955 355.28C344.089 355.28 344.859 355.868 345.125 356.792H346.497C346.105 355.182 344.859 354.202 342.955 354.202C340.771 354.202 339.217 355.742 339.217 358.15ZM351.459 355.28C352.775 355.28 353.895 356.106 353.881 357.604H349.037C349.177 356.106 350.213 355.28 351.459 355.28ZM355.043 359.634H353.671C353.391 360.46 352.663 361.048 351.515 361.048C350.213 361.048 349.121 360.194 349.023 358.64H355.155C355.183 358.374 355.197 358.15 355.197 357.87C355.197 355.77 353.741 354.202 351.515 354.202C349.275 354.202 347.721 355.728 347.721 358.15C347.721 360.586 349.331 362.126 351.515 362.126C353.419 362.126 354.651 361.034 355.043 359.634ZM358.125 361.216C358.125 360.726 357.747 360.348 357.285 360.348C356.795 360.348 356.417 360.726 356.417 361.216C356.417 361.706 356.795 362.084 357.285 362.084C357.747 362.084 358.125 361.706 358.125 361.216Z" fill="#263238"/>
                </svg>
            </div>
        </div>
    </div>
</div>
</body>
</html>




