<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(getAppName()); ?></title>
    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(asset(getSettingValue('favicon_icon'))); ?>" type="image/png">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="current-date-format" content="<?php echo e(currentDateFormat()); ?>">

    <!-- Fonts -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />

    <!-- General CSS Files -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/third-party.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(mix('assets/css/page.css')); ?>">
    <?php if(!Auth::user()->dark_mode): ?>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/style.css')); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/plugins.css')); ?>">
        <link href="<?php echo e(mix('assets/css/full-screen.css')); ?>" rel="stylesheet" type="text/css" />
    <?php else: ?>
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/style.dark.css')); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/plugins.dark.css')); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/phone-number-dark.css')); ?>">
        <link rel="stylesheet" type="text/css" href="https://npmcdn.com/flatpickr/dist/themes/dark.css">
    <?php endif; ?>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <script src="https://cdn.jsdelivr.net/gh/livewire/turbolinks@v0.1.x/dist/livewire-turbolinks.js"
        data-turbolinks-eval="false" data-turbo-eval="false"></script>
    <script src="https://js.stripe.com/v3/"></script>
    <script src="https://checkout.razorpay.com/v1/checkout.js" data-turbolinks-eval="false" data-turbo-eval="false">
    </script>
    <script src="<?php echo e(asset('assets/js/third-party.js')); ?>"></script>
    <script src="<?php echo e(asset('messages.js')); ?>"></script>
    <script data-turbo-eval="false">
        let sweetAlertIcon = "<?php echo e(asset('images/remove.png')); ?>";
        let decimalsSeparator = "<?php echo e(getSettingValue('decimal_separator')); ?>";
        let thousandsSeparator = "<?php echo e(getSettingValue('thousand_separator')); ?>";
        let changePasswordUrl = "<?php echo e(route('user.changePassword')); ?>";
        let currentDateFormat = "<?php echo e(currentDateFormat()); ?>";
        let momentDateFormat = "<?php echo e(momentJsCurrentDateFormat()); ?>";
        var phoneNo = '';
        let getUserLanguages = "<?php echo e(getCurrentLanguageName()); ?>";
        Lang.setLocale(getUserLanguages);
        let currentRouteName = "<?php echo e(Route::currentRouteName()); ?>";
    </script>
    <?php echo app('Tightenco\Ziggy\BladeRouteGenerator')->generate(); ?>
    <script src="<?php echo e(mix('assets/js/pages.js')); ?>"></script>
</head>

<body class="overflow-x-hidden">
    <?php echo $__env->yieldContent('phone_js'); ?>
    <div class="d-flex flex-column flex-root">
        <div class="d-flex flex-row flex-column-fluid">
            <?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="wrapper d-flex flex-column flex-row-fluid overflow-x-hidden">
                <div class='container-fluid d-flex align-items-stretch justify-content-between px-0'>
                    <?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class='content d-flex flex-column flex-column-fluid pt-7'>
                    <?php echo $__env->yieldContent('header_toolbar'); ?>
                    <div class='d-flex flex-wrap flex-column-fluid'>
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>
                <div class='container-fluid'>
                    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('profile.changePassword', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('profile.changelanguage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>


</html>
<?php /**PATH /home/elitdevs/accounting-1.elitdevs.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>